CREATE TABLE trucks (
    id integer NOT NULL
);

CREATE TABLE imported_beer (
    id integer NOT NULL,
    truck_id integer,
    brand character varying(50) NOT NULL,
    price double precision NOT NULL,
    country character varying(50) NOT NULL,
    import_duty double precision NOT NULL
);

CREATE TABLE domestic_beer (
    id integer NOT NULL,
    truck_id integer,
    brand character varying(50) NOT NULL,
    price double precision NOT NULL
);

CREATE TABLE pubs (
    id integer NOT NULL,
    name character varying(50) NOT NULL,
    debt double precision
);

CREATE TABLE ojb_hl_seq (
    tablename character varying(175) NOT NULL,
    fieldname character varying(70) NOT NULL,
    max_key integer,
    grab_size integer,
    "version" integer
);

ALTER TABLE ONLY trucks
    ADD CONSTRAINT trucks_pkey PRIMARY KEY (id);

ALTER TABLE ONLY imported_beer
    ADD CONSTRAINT imported_beer_pkey PRIMARY KEY (id);

ALTER TABLE ONLY domestic_beer
    ADD CONSTRAINT domestic_beer_pkey PRIMARY KEY (id);

ALTER TABLE ONLY pubs
    ADD CONSTRAINT pubs_pkey PRIMARY KEY (id);

ALTER TABLE ONLY domestic_beer
    ADD CONSTRAINT truck_fk FOREIGN KEY (truck_id) REFERENCES trucks(id);

ALTER TABLE ONLY imported_beer
    ADD CONSTRAINT truck_fk FOREIGN KEY (truck_id) REFERENCES trucks(id);
