
import java.util.*;

/**
 * A place to drink beer
 */
public class Pub {
    private Integer id;
    private String name;
    private Double debt;
    private Set<Beer> bar = new HashSet<Beer>();

    /**
     * Create yet another fake Irish pub
     */
    public Pub() {
        this("Fake Irish Pub");
    }

    public Pub(String name) {
        this.name = name;
        debt = new Double(0);
    }

    public String getName() {
        return this.name;
    }

    public double getDebt() {
        return debt.doubleValue();
    }

    public void addStock(Collection<Beer> beer) {
        synchronized (this.debt) {
            double debt = this.debt.doubleValue();
            for (Iterator<Beer> iterator = beer.iterator(); iterator.hasNext();) {
                Beer can = iterator.next();
                debt += can.getPrice();
                this.bar.add(can);
            }
            this.debt = new Double(debt);
        }
    }


    public Set<Beer> getBeersOnTap() {
        HashMap<String, Beer> beers = new HashMap<String, Beer>();
        for (Iterator<Beer> iterator = bar.iterator(); iterator.hasNext();) {
            Beer beer = iterator.next();
            beers.put(beer.getBrand(), beer);
        }
        return new HashSet<Beer>(beers.values());
    }
}
